using System;

namespace gov.va.med.vbecs.BOL
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>Exception called when too many records are returned for a given data access operation</summary>

		#endregion

	public class TooManyRecordsFoundException : BusinessObjectException
	{
		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1343"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>TooManyRecordsFoundException</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1298"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Empty constructor for error when too many records are returned
		/// </summary>
		public TooManyRecordsFoundException() : base()
		{
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1344"> 
		///		<ExpectedInput>Valid string</ExpectedInput>
		///		<ExpectedOutput>TooManyRecordsFoundException with input string</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1622"> 
		///		<ExpectedInput>Null string</ExpectedInput>
		///		<ExpectedOutput>Generic error message</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor for error when too many records are returned
		/// </summary>
		public TooManyRecordsFoundException(string message) : base(message)
		{
		} 

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/21/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1345"> 
		///		<ExpectedInput>string, innerexception</ExpectedInput>
		///		<ExpectedOutput>TooManyRecordsFoundException with input string and inner exception</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1623"> 
		///		<ExpectedInput>Null input string and inner exception</ExpectedInput>
		///		<ExpectedOutput>Generic error message and null inner exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Constructor for error when too many records are returned
		/// </summary>
		public TooManyRecordsFoundException(string message, Exception inner) : base(message, inner)
		{
		}

	}
}

